; Floating point library demo program
; Notionally for a PIC16F84, but intended to be run on a simulator
; such as that in MPLAB.
; Calculates 4*PI*r*r*r/3, where r = 20.3
; Malcolm Wiles, 4 June 04

	LIST P=16F84,R=DEC
	INCLUDE P16F84.inc

	INCLUDE fpdefs.inc	; floating point definitions

;**********************************************************************************************
; Variable definitions required by Microchip floating point library
;
; Note that the absolute locations used may be changed, but these variables should be allocated
; a contiguous block of data memory, and the relative order should stay the same.
;
;       general register variables
;

SIGN            equ     0x49    ; save location for sign in MSB
TEMPB1          equ     0x4A
TEMP            equ     0x4B    ; temporary storage

;	exception flags and option bits

FPFLAGS         equ     0x42    ; floating point library exception flags

;
;       binary operation arguments
;

AARGB4          equ     0x43
AARGB3          equ     0x44
AARGB2          equ     0x45
AARGB1          equ     0x46
AARGB0          equ     0x47
AEXP            equ     0x48    ; 8 bit biased exponent for argument A
EXP             equ     0x48    ; 8 bit biased exponent - same location as AEXP

BARGB2          equ     0x4C
BARGB1          equ     0x4D
BARGB0          equ     0x4E
BEXP            equ     0x4F    ; 8 bit biased exponent for argument B

;
;**********************************************************************************************


;  User-written code starts here

	org	0		; start vector
	goto	start
	org	4
	retfie			; interrupt vector (not used)

start

	clrf	FPFLAGS		; initialise flags to zero
	bsf	FPFLAGS,RND	; set RND for best accuracy

	movlw	0
	movwf	AARGB0
	movlw	4
	movwf	AARGB1		; load 4 into AARG
	call	FLOAT		; and convert to floating point
br1	NOP			; for breakpoint
	andlw	0xFF		; check FLOAT worked OK
	btfss	STATUS,Z		; Z set if W is zero
	goto	err		; W not zero so jump to error code

; 4 in floating point is now in AARG
; next multiply by PI

	movlw	PIEXP		; PI in floating point (defined in FPDEFS.INC)
	movwf	BEXP		; copy into BARG
	movlw	PIB0
	movwf	BARGB0
	movlw	PIB1
	movwf	BARGB1

	call	FPM		; floating point multiply
br2	NOP			; for breakpoint
	andlw	0xFF		; check FPM worked OK
	btfss	STATUS,Z	; Z set if W is zero
	goto	err		; W not zero so jump to error code

; next multiply by r (20.3)
; 20.3 is 0x832266 in floating point
; this value obtained using tofp.exe
	
	movlw	0x83		; copy 20.3 in fp to BARG
	movwf	BEXP
	movlw	0x22
	movwf	BARGB0
	movlw	0x66
	movwf	BARGB1		
	call	FPM		; multiply - ans in AARG
br3	NOP			; for breakpoint
	andlw	0xFF		; check FPM worked OK
	btfss	STATUS,Z		; Z set if W is zero
	goto	err		; W not zero so jump to error code

; now multiply by r again for r squared
; note that it must be assumed that BARG has been corrupted
; by the previous call, so we need to load it again
	
	movlw	0x83
	movwf	BEXP
	movlw	0x22
	movwf	BARGB0
	movlw	0x66
	movwf	BARGB1
	call	FPM
br4	NOP
	andlw	0xFF
	btfss	STATUS,Z
	goto	err

; and a third time to multiply by r cubed
	
	movlw	0x83
	movwf	BEXP
	movlw	0x22
	movwf	BARGB0
	movlw	0x66
	movwf	BARGB1
	call	FPM
br5	NOP
	andlw	0xFF
	btfss	STATUS,Z
	goto	err

; now divide by 3 which is 0x804000 in floating point, obtained from tofp.exe

	movlw	0x80
	movwf	BEXP
	movlw	0x40
	movwf	BARGB0
	movlw	0x00
	movwf	BARGB1
	call	FPD		; floating point divide
br6	NOP
	andlw	0xFF
	btfss	STATUS,Z
	goto	err

; and finally FIX the result to represent it as the nearest integer
; result in AARG

	call	FIX
br7	NOP
	andlw	0xFF
	btfss	STATUS,Z
	goto	err

; loopstop at the end of the program
	
stop	goto	stop
	btfss	STATUS,Z

; program jumps here if a floating point error occurs
; normally you would put code here to see what exception has occurred
; by testing the bits in FPFLAGS, and then handle the error
; but since this is just a demo program we simply loopstop

err	nop
	goto	err

; include the floating point routines

	include fpcode.inc	; the floating point code

	END

